/* - EncoderDetachListener -
 * We'll clear our display fields and disable our editable fields while device 
 * is not attached as trying to communicate with the device while not attached 
 * will generate a PhidgetException.  In this example, I have coded so that 
 * this should not occur, but best practice would be to catch it and handle 
 * it accordingly
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.EncoderPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.DetachListener;
import com.phidgets.event.DetachEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JCheckBox;

public class EncoderDetachListener implements DetachListener{
    
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numEncodersTxt;
    private JTextField numInTxt;
    private JCheckBox inputChk;
    private JTextField relChngTxt;
    private JTextField timeTxt;
    private JTextField posTxt;
    
    /**
     * Creates a new instance of EncoderDetachListener
     */
    public EncoderDetachListener(JFrame appFrame, JTextField attachedTxt,
            JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt,
            JTextField numEncodersTxt, JTextField numInTxt, JCheckBox inputChk,
            JTextField relChngTxt, JTextField timeTxt, JTextField posTxt)
    {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numEncodersTxt = numEncodersTxt;
        this.numInTxt = numInTxt;
        this.inputChk = inputChk;
        this.relChngTxt = relChngTxt;
        this.timeTxt = timeTxt;
        this.posTxt = posTxt;
    }

    public void detached(DetachEvent de)
    {
        try
        {
            EncoderPhidget detached = (EncoderPhidget)de.getSource();
            attachedTxt.setText(Boolean.toString(detached.isAttached()));
            nameTxt.setText("");
            serialTxt.setText("");
            versionTxt.setText("");
            numEncodersTxt.setText("");
            numInTxt.setText("");
            relChngTxt.setText("");
            timeTxt.setText("");
            posTxt.setText("");
            
            inputChk.setSelected(false);
            inputChk.setVisible(false);
        }
        catch(PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
